<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 16.01.2025

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
requireLogin();
requireRole(['Bediener', 'Bearbeiter', 'Administrator']);
?>
<table class="table console">
    <thead>
        <tr>
            <th colspan="2">Karte</th>
            <th>Zone</th>
            <th class="text-end">Gebucht</th>
        </tr>
    </thead>
    <?php
    try {

        initializeDatabaseConnection();

        $sql = "
            SELECT *
            FROM Identities
            WHERE (NOW() BETWEEN IdentityIN AND IdentityOUT
               OR DATE(NOW()) = DATE(IdentityIN)
               OR DATE(NOW()) = DATE(IdentityOUT))
            AND AccessCard IS NOT NULL
            AND AccessCard != ''
            ORDER BY MAX(ZoneEntryTimestamp) OVER (PARTITION BY Type) DESC, Type ASC, ZoneEntryTimestamp DESC
    ";

        // Abfrage vorbereiten und ausführen
        $stmt = $pdo->prepare($sql);
        $stmt->execute();

        // Ergebnisse abrufen
        $accessCards = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Prüfen, ob Ergebnisse vorhanden sind
        if ($accessCards) {

            $currentType = '';

            foreach ($accessCards as $card) {

                if ($currentType !== $card['Type']) {

                    $currentType = $card['Type'];

                    if ($card['Type'] == 'Military') {
                        $typeName = 'Soldaten';
                    } elseif ($card['Type'] == 'Local') {
                        $typeName = 'Ortskräfte';
                    } elseif ($card['Type'] == 'Civil') {
                        $typeName = 'Zivilisten';
                    } elseif ($card['Type'] == 'Guest') {
                        $typeName = 'Gäste';
                    }

                    echo "<tr><td colspan='4' class='bg-light pt-1 pb-1 text-primary text-uppercase fs-12px' style='letter-spacing: 1px;'>" . $typeName . "</td></tr>";

                }

                echo '<tr>';

                echo '<td width="10%"><span class="fc-event fc-h-event fc-daygrid-event fc-daygrid-block-event"><span class="fc-event-main">' . $card['AccessCard'] . '</span></span></td>';

                echo '<td><span class="' . ((isset($_COOKIE['dataPrivacy']) && $_COOKIE['dataPrivacy'] === 'true') ? 'bg-light text-light' : 'text-secondary') . '">' . $card['Rank'] . ' ' . $card['Surname'] . ', ' . $card['Givenname'] . '</span></td>';

                echo '<td>';
                if (!empty($card['CurrentZone'])) {
                    echo '<span style="color: ' . getZoneDetails($card['CurrentZone'], 'ZoneColor') . '">' . getZoneDetails($card['CurrentZone'], 'ZoneName') . '</span>';
                } else {
                    echo '<span class="text-warning">Keine Buchungshistorie</span>';
                }
                echo '</td>';

                echo '<td class="text-end">';
                if (!empty($card['ZoneEntryTimestamp'])) {
                    $timestamp = strtotime($card['ZoneEntryTimestamp']);
                    $current_time = time();
                    $currentDate = date('Y-m-d');
                    $entryDate = date('Y-m-d', $timestamp);

                    if ($current_time - $timestamp < 15) {
                        echo "<span class='text-success fw-bold'>Gerade eben <i class='mdi mdi-creation' style='font-size: 16px; line-height: 10px;'></i></span>";
                    } elseif ($currentDate === $entryDate) {
                        // Am aktuellen Datum, nur Uhrzeit anzeigen
                        echo '<span>' . date('H:i:s', $timestamp) . '</span>';
                    } else {
                        // An einem anderen Datum, vollständigen Timestamp anzeigen
                        echo '<span>' . $card['ZoneEntryTimestamp'] . '</span>';
                    }
                } else {
                    echo '<span class="text-warning">N/A</span>';
                }
                echo '</td>';

                echo '</tr>';
            }
        } else {
            echo '<td colspan="4">Keine Personen in der Zone</td>';
        }

    } catch (PDOException $e) {
        echo 'Datenbankfehler: ' . $e->getMessage();
    }

    ?>
</table>